//#12.00Aa WDOnglet.JS
//VersionVI: 30F120055n
// Le seul support technique disponible pour cette librairie est
// accessible a travers le service "Assistance Directe".

// Manipulation des onglets

// Manipule un volet
function WDVolet (oOnglet, nIndiceVolet)
{
	// + 1 car les volets sont avec les indices WL donc qui commencent a 1
	var sAlias = oOnglet.m_sAlias + '_' + (nIndiceVolet + 1);
	// Trouve les elements : titre et corps
	this.m_oTitre = oGetId(sAlias);
	this.m_oCorps = oGetId('dww' + sAlias);
	this.m_oLien = this.m_oTitre.getElementsByTagName("A")[0];

	// Hook le clic dans le titre
	var oTmp = this;
	var oTmpOnglet = oOnglet;
	this.m_fOnClick = this.m_oTitre.onclick;

	if (this.m_oTitre && bIE)
	{
		this.m_oTitre.onclick = function () { oTmpOnglet.OnClick(event, nIndiceVolet); if (oTmp.m_fOnClick) { oTmp.m_fOnClick.apply(this.m_oTitre, [event]); } };
	}
	else
	{
		this.m_oTitre.onclick = function (event) { oTmpOnglet.OnClick(event, nIndiceVolet); if (oTmp.m_fOnClick) { oTmp.m_fOnClick.apply(this.m_oTitre, [event]); } };
	}
}

WDVolet.prototype =
{
//	m_oTitre:	null,
//	m_oCorps:	null,
//	m_oLien:	null,
//	m_fOnClick:	null,

	Affiche:function (bAffiche, oOnglet)
	{
		// Affiche ou masque le volet
		this.m_oCorps.style.display = bAffiche ? 'block' : 'none';

		// Change le style du volet
		this.m_oTitre.className = oOnglet.m_tabStyle[bAffiche ? oOnglet.nStyleActif : oOnglet.nStyleInactif];

		// Supprime ou affiche la barre de separation
		switch (oOnglet.m_ePosition)
		{
		case oOnglet.ePosVolet_Haut:
			this.m_oTitre.style.borderBottomWidth = bAffiche ? '0px' : '1px';
			break;
		case oOnglet.ePosVolet_Bas:
			this.m_oTitre.style.borderTopWidth = bAffiche ? '0px' : '1px';
			break;
		case oOnglet.ePosVolet_Gauche:
			this.m_oTitre.style.borderRightWidth = bAffiche ? '0px' : '1px';
			break;
		case oOnglet.ePosVolet_Droite:
			this.m_oTitre.style.borderLeftWidth = bAffiche ? '0px' : '1px';
			break;
		}
	},

	// Calcule si le lien est actif
	bActif:function ()
	{
		// Si le lien est gris
		if (this.m_oLien.disabled)
		{
			return false;
		}
		
		// Si le lien est dsactiv
		if (this.m_oLien.readOnly || this.m_oLien.attributes["READONLY"])
		{
			return false;
		}

		return true;
	},

	// Change la hauteur du volet
	Hauteur:function (nHauteur)
	{
		this.m_oCorps.firstChild.firstChild.firstChild.height = nHauteur + "px";
	}
}

// Manipulation des onglets
function WDOnglet (sAliasOnglet, nNbOnglets, ePosition, tabStyle)
{
	this.m_sAlias = sAliasOnglet;
	this.m_nNbOnglets = nNbOnglets;
	this.m_tabOnglets = new Array();
	this.m_ePosition = ePosition;
	this.m_tabStyle = tabStyle;
}

WDOnglet.prototype =
{
//	m_sAlias:			'',
//	m_nNbOnglets:		1,
//	m_nOngletActif:		1,
//	m_tabOnglets:		new Array(),
//	m_ePosition:		ePosVolet_Haut,
//	m_tabStyle:			new Array(),
//	m_fPCodeModificationSimpleNav:undefined,
	ePosVolet_Haut:		0,
	ePosVolet_Bas:		1,
	ePosVolet_Gauche:	2,
	ePosVolet_Droite:	3,
	nStyleActif:		0,
	nStyleInactif:		1,

	Init:function ()
	{
		// Construit le tableau des onglets
		var i;
		var nLimiteI = this.m_nNbOnglets;
		for (i = 0; i < nLimiteI; i++)
		{
			// Construit un onglet
			this.m_tabOnglets.push(new WDVolet(this, i));
		}
	},

	// Code de modification navigateur
	CodeModificationSimple:function (sFonctionModification)
	{
		this.m_fPCodeModificationSimpleNav = new Function("event", "return " + sFonctionModification + ";");
	},

	// Affiche un volet sur un clic utilisateur
	OnClick:function (oEvent, nIndiceVolet)
	{
		// N'active le volet que s'il est actif
		if (this.m_tabOnglets[nIndiceVolet].bActif())
		{
			// Active le volet
			this.AfficheVolet(nIndiceVolet);
		}

		// Appel le PCode navigateur de modification
		if (this.m_fPCodeModificationSimpleNav)
			this.m_fPCodeModificationSimpleNav(oEvent);
	},

	// Affiche un volet
	AfficheVolet:function (nIndiceVolet)
	{
		// Masque tous les volets sauf le volet a activer
		var i;
		var nLimiteI = this.m_nNbOnglets;
		for (i = 0; i < nLimiteI; i++)
		{
			// Masque le volet
			if (i != nIndiceVolet)
				this.m_tabOnglets[i].Affiche(false, this);
		}
		this.m_tabOnglets[nIndiceVolet].Affiche(true, this);

		// Change la valeur du champ cache qui donne l'onglet affiche
		// + 1 car l'indice est WL pour :
		//	- La lecture en JS
		//	- Le submit au serveur qui prend un indice WL
		document.getElementsByName(this.m_sAlias)[0].value = nIndiceVolet + 1;
	},

	// Change la hauteur des onglets (pour l'AJAX)
	HauteurVolet:function (nHauteur)
	{
		// Applique la mthode sur tous les volets
		var i;
		var nLimiteI = this.m_nNbOnglets;
		for (i = 0; i < nLimiteI; i++)
		{
			// Change la taille
			this.m_tabOnglets[i].Hauteur(nHauteur);
		}
	}
}
